"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const typesense_1 = __importDefault(require("typesense"));
let clientTypesense = new typesense_1.default.Client({
    nodes: [
        {
            host: process.env.TYPESENSE_HOST || "", // For Typesense Cloud use xxx.a1.typesense.net
            port: 443, // For Typesense Cloud use 443
            protocol: "https", // For Typesense Cloud use https
        },
    ],
    apiKey: process.env.TYPESENSE_API_KEY || "",
    connectionTimeoutSeconds: 2,
});
exports.default = clientTypesense;
