"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.editRekamanSchema = exports.createRekamanSchema = void 0;
const zod_1 = require("zod");
const createRekamanSchema = zod_1.z.object({
    isManual: zod_1.z.boolean().optional(),
    title: zod_1.z.string().min(1, "Rekaman title is required."),
    rekamanFolderId: zod_1.z.string().min(1, "Rekaman Folder is required."),
    content: zod_1.z.string().optional(),
    extension: zod_1.z.string().optional(),
});
exports.createRekamanSchema = createRekamanSchema;
const editRekamanSchema = zod_1.z.object({
    title: zod_1.z.string().min(1, "Rekaman title is required.").optional(),
    newRekamanFolderId: zod_1.z.string().optional(),
    content: zod_1.z.string().optional(),
    invitedUsers: zod_1.z
        .array(zod_1.z.object({
        id: zod_1.z.string().min(1, "User ID is required."),
        role: zod_1.z.enum(["viewer", "editor", "owner"]),
    }))
        .optional(),
    revokedUsers: zod_1.z
        .array(zod_1.z.object({
        id: zod_1.z.string().min(1, "User ID is required."),
    }))
        .optional(),
    extension: zod_1.z.string().optional(),
});
exports.editRekamanSchema = editRekamanSchema;
