"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createRekamanSchema = exports.createDocumentSchema = void 0;
const zod_1 = require("zod");
const createDocumentSchema = zod_1.z.object({
    title: zod_1.z.string().min(1, "Document title is required."),
    divisiFolderId: zod_1.z.string().min(1, "Divisi Folder is required."),
    tags: zod_1.z.string().min(1, "Tags Document is required."),
    status: zod_1.z.string().min(1, "Status Document is required."),
    extension: zod_1.z.string().optional(),
    categoryId: zod_1.z.string().min(1, "Category ID is required."),
});
exports.createDocumentSchema = createDocumentSchema;
const createRekamanSchema = zod_1.z.object({
    title: zod_1.z.string().min(1, "Document title is required."),
    rekamanFolderId: zod_1.z.string().min(1, "Rekaman Folder is required."),
    extension: zod_1.z.string().optional(),
});
exports.createRekamanSchema = createRekamanSchema;
