"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.editFolderSchema = exports.createFolderSchema = void 0;
const zod_1 = require("zod");
const createFolderSchema = zod_1.z.object({
    folderName: zod_1.z.string().min(1, "Folder Name is required"),
    description: zod_1.z.string().min(1, "Description is required"),
    invitedUsers: zod_1.z
        .array(zod_1.z.object({
        id: zod_1.z.string().min(1, "User ID is required."),
        role: zod_1.z.enum(["viewer", "editor", "owner"]),
    }))
        .optional(),
    parentFolderId: zod_1.z.string().nullable().optional(),
});
exports.createFolderSchema = createFolderSchema;
const editFolderSchema = zod_1.z.object({
    folderName: zod_1.z.string().min(1, "Folder Name is required").optional(),
    description: zod_1.z.string().min(1, "Description is required").optional(),
    invitedUsers: zod_1.z
        .array(zod_1.z.object({
        id: zod_1.z.string().min(1, "User ID is required."),
        role: zod_1.z.enum(["viewer", "editor", "owner"]),
    }))
        .optional(),
    revokedUsers: zod_1.z
        .array(zod_1.z.object({
        id: zod_1.z.string().min(1, "User ID is required."),
    }))
        .optional(),
    newParentFolderId: zod_1.z.string().optional(),
});
exports.editFolderSchema = editFolderSchema;
