"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.userUpdateSchema = void 0;
const zod_1 = require("zod");
const phoneRegex = /^(\+?[\d\s-]{1,4})?[\s-]?(\(?\d{2,4}\)?[\s-]?)?[\d\s-]{3,}$/;
const userUpdateSchema = zod_1.z.object({
    name: zod_1.z.string().optional(),
    email: zod_1.z.string().email().optional(),
    password: zod_1.z.string().min(6).optional(),
    phoneNumber: zod_1.z
        .string()
        .regex(phoneRegex, "Invalid Number!")
        .optional()
        .or(zod_1.z.literal("")),
    newDocumentNotification: zod_1.z
        .union([zod_1.z.boolean(), zod_1.z.string().transform((val) => val === "true")])
        .optional(),
    commentNotification: zod_1.z
        .union([zod_1.z.boolean(), zod_1.z.string().transform((val) => val === "true")])
        .optional(),
    approvalNotification: zod_1.z
        .union([zod_1.z.boolean(), zod_1.z.string().transform((val) => val === "true")])
        .optional(),
    taskNotification: zod_1.z
        .union([zod_1.z.boolean(), zod_1.z.string().transform((val) => val === "true")])
        .optional(),
});
exports.userUpdateSchema = userUpdateSchema;
