"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const workspace_1 = require("../app/controllers/api/v1/workspace");
const multer_1 = __importDefault(require("multer"));
const verifyToken_1 = __importDefault(require("../middlewares/verifyToken"));
const router = express_1.default.Router();
const upload = (0, multer_1.default)();
router.post("/v1/workspace", upload.single("image"), verifyToken_1.default, workspace_1.createWorkspace);
router.get("/v1/workspace", verifyToken_1.default, workspace_1.getAllWorkspaces);
router.put("/v1/updateDefaultWorkspace", upload.single("image"), verifyToken_1.default, workspace_1.updateDefaultWorkspace);
router.delete("/v1/workspace/:workspaceId", verifyToken_1.default, workspace_1.deleteWorkspace);
exports.default = router;
