"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const multer_1 = __importDefault(require("multer"));
const task_1 = require("../app/controllers/api/v1/task");
const verifyToken_1 = __importDefault(require("../middlewares/verifyToken"));
const router = express_1.default.Router();
const upload = (0, multer_1.default)();
router.post("/v1/task/:workspaceId", upload.none(), verifyToken_1.default, task_1.createTask);
router.put("/v1/task/:workspaceId/:taskId", upload.none(), verifyToken_1.default, task_1.editTask);
router.put("/v1/submitTask/:workspaceId/:taskId", upload.none(), verifyToken_1.default, task_1.submitTask);
router.post("/v1/tasks/:taskId/comments", upload.none(), verifyToken_1.default, task_1.addComment);
router.put("/v1/tasks/:taskId/comments/:commentId", upload.none(), verifyToken_1.default, task_1.editComment);
router.delete("/v1/tasks/:taskId/comments/:commentId", verifyToken_1.default, task_1.deleteComment);
router.get("/v1/viewTask/:workspaceId/:taskId", verifyToken_1.default, task_1.viewTask);
router.get("/v1/tasks/receiver/:workspaceId", verifyToken_1.default, task_1.viewTaskByPIC);
router.get("/v1/tasks/creator/:workspaceId", verifyToken_1.default, task_1.viewTaskByCreator);
router.delete("/v1/deleteTask/:workspaceId/:taskId", upload.none(), verifyToken_1.default, task_1.deleteTask);
exports.default = router;
