"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const multer_1 = __importDefault(require("multer"));
const verifyToken_1 = __importDefault(require("../middlewares/verifyToken"));
const rekamanFolder_1 = require("../app/controllers/api/v1/rekamanFolder");
const router = express_1.default.Router();
const upload = (0, multer_1.default)();
router.post("/v1/rekamanFolder/:workspaceId", upload.none(), verifyToken_1.default, rekamanFolder_1.createRekamanFolder);
router.delete("/v1/rekamanFolder/:workspaceId/:rekamanFolderId", verifyToken_1.default, rekamanFolder_1.deleteRekamanFolder);
router.put("/v1/rekamanFolder/:workspaceId/:rekamanFolderId", upload.none(), verifyToken_1.default, rekamanFolder_1.editRekamanFolder);
router.get("/v1/rekamanFolder/:workspaceId", verifyToken_1.default, rekamanFolder_1.viewAllRekamanFolders);
router.get("/v1/rekamanFolder/:workspaceId/:rekamanFolderId", verifyToken_1.default, rekamanFolder_1.viewRekamanFolder);
exports.default = router;
