"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const onlyoffice_1 = require("../app/controllers/api/v1/onlyoffice");
const verifyToken_1 = __importDefault(require("../middlewares/verifyToken"));
const multer_1 = __importDefault(require("multer"));
const router = express_1.default.Router();
const upload = (0, multer_1.default)();
router.get("/v1/viewDocumentOffice/:workspaceId/:divisiFolderId/:documentId", verifyToken_1.default, onlyoffice_1.viewDocumentOffice);
router.get("/v1/viewRekamanOffice/:workspaceId/:rekamanFolderId/:rekamanId", verifyToken_1.default, onlyoffice_1.viewRekamanOffice);
router.get("/v1/viewDocumentApprovalOffice/:workspaceId/:documentApprovalId", verifyToken_1.default, onlyoffice_1.viewDocumentApprovalOffice);
router.post("/v1/restoreDocumentOffice/:documentId", upload.none(), onlyoffice_1.restoreDocumentOffice);
router.post("/v1/restoreRekamanoffice/:rekamanId", upload.none(), onlyoffice_1.restoreRekamanOffice);
router.post("/v1/convertDocumentOffice/:documentId", verifyToken_1.default, onlyoffice_1.convertDocumentOfficePDF);
router.post("/v1/trackDocumentOffice", onlyoffice_1.trackDocumentOffice);
router.post("/v1/trackRekamanOffice", onlyoffice_1.trackRekamanOffice);
router.post("/v1/trackDocumentApprovalOffice", onlyoffice_1.trackDocumentApprovalOffice);
router.post("/v1/createDocumentOffice/:workspaceId", upload.none(), verifyToken_1.default, onlyoffice_1.createNewFileFromTemplate);
router.post("/v1/createRekamanFile/:workspaceId", upload.none(), verifyToken_1.default, onlyoffice_1.createNewRekamanFileFromTemplate);
exports.default = router;
