"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const multer_1 = __importDefault(require("multer"));
const documentApproval_1 = require("../app/controllers/api/v1/documentApproval");
const verifyToken_1 = __importDefault(require("../middlewares/verifyToken"));
const router = express_1.default.Router();
const upload = (0, multer_1.default)();
router.post("/v1/docuSealToken/:workspaceId/:divisiFolderId/:documentId", upload.none(), verifyToken_1.default, documentApproval_1.generateDocuSealToken);
router.post("/v1/submitDocuSealDocument/:documentApprovalId", upload.none(), verifyToken_1.default, documentApproval_1.submitDocumentApprovalDocuSeal);
router.post("/v1/documentApproval/:workspaceId/:divisiFolderId/:documentId", upload.none(), verifyToken_1.default, documentApproval_1.sendDocumentApprovalRequest);
router.post("/v1/manualDocumentApproval/:workspaceId/:divisiFolderId/:documentId", upload.none(), verifyToken_1.default, documentApproval_1.sendManualDocumentApproval);
router.get("/v1/documentApproval/:workspaceId", upload.none(), verifyToken_1.default, documentApproval_1.viewDocumentApprovals);
router.get("/v1/documentRequesterApproval/:workspaceId", upload.none(), verifyToken_1.default, documentApproval_1.viewDocumentReceiverApprovals);
router.get("/v1/documentManualReceiverApproval/:workspaceId", upload.none(), verifyToken_1.default, documentApproval_1.viewManualDocumentReceiverApprovals);
router.get("/v1/documentManualRequesterApproval/:workspaceId", upload.none(), verifyToken_1.default, documentApproval_1.viewManualDocumentApprovals);
router.put("/v1/documentApproval/:approvalId", upload.none(), verifyToken_1.default, documentApproval_1.editDocumentApproval);
router.delete("/v1/documentApproval/:documentApprovalId", verifyToken_1.default, documentApproval_1.deleteDocumentApproval);
exports.default = router;
