"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const multer_1 = __importDefault(require("multer"));
const document_1 = require("../app/controllers/api/v1/document");
const verifyToken_1 = __importDefault(require("../middlewares/verifyToken"));
const router = express_1.default.Router();
const upload = (0, multer_1.default)();
router.post("/v1/document/:workspaceId", upload.single("docs"), verifyToken_1.default, document_1.createDocument);
router.put("/v1/updateDocument/:workspaceId/:divisiFolderId/:documentId", upload.single("docs"), verifyToken_1.default, document_1.editDocument);
router.get("/v1/viewAllDocuments/:workspaceId", verifyToken_1.default, document_1.viewAllDocuments);
router.get("/v1/viewAllDocumentsinFolder/:workspaceId/:divisiFolderId", verifyToken_1.default, document_1.viewAllDocumentsInFolder);
router.get("/v1/viewDocument/:workspaceId/:divisiFolderId/:documentId", verifyToken_1.default, document_1.viewDocument);
router.get("/v1/viewDocumentFile/:workspaceId/:divisiFolderId/:documentId", verifyToken_1.default, document_1.getDocumentFile);
router.delete("/v1/deleteDocument/:workspaceId/:divisiFolderId/:documentId", verifyToken_1.default, document_1.deleteDocument);
exports.default = router;
