"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const multer_1 = __importDefault(require("multer"));
const divisiFolder_1 = require("../app/controllers/api/v1/divisiFolder");
const verifyToken_1 = __importDefault(require("../middlewares/verifyToken"));
const router = express_1.default.Router();
const upload = (0, multer_1.default)();
router.post("/v1/divisiFolder/:workspaceId", upload.none(), verifyToken_1.default, divisiFolder_1.createDivisiFolder);
router.put("/v1/updateDivisiFolder/:workspaceId/:folderId", upload.none(), verifyToken_1.default, divisiFolder_1.editDivisiFolder);
router.get("/v1/viewAllDivisiFolders/:workspaceId", verifyToken_1.default, divisiFolder_1.viewAllDivisiFolders);
router.get("/v1/viewFolder/:workspaceId/:folderId", verifyToken_1.default, divisiFolder_1.viewFolder);
router.get("/v1/folders/:workspaceId/:folderId/subFolders", verifyToken_1.default, divisiFolder_1.viewFolderWithSubfolders);
router.delete("/v1/divisiFolder/:workspaceId/:folderId", verifyToken_1.default, divisiFolder_1.deleteFolder);
router.post("/v1/migrateDivisiFolder", divisiFolder_1.migrateAllFoldersToSearchableDivisiFolder);
exports.default = router;
