"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const multer_1 = __importDefault(require("multer"));
const commentsNotification_1 = require("../app/controllers/api/v1/commentsNotification");
const verifyToken_1 = __importDefault(require("../middlewares/verifyToken"));
const router = express_1.default.Router();
const upload = (0, multer_1.default)();
router.post("/v1/:workspaceId/notifications/:notificationId/comments", upload.none(), verifyToken_1.default, commentsNotification_1.createComment);
router.put("/v1/:workspaceId/notifications/:notificationId/comments/:commentId", upload.none(), verifyToken_1.default, commentsNotification_1.updateComment);
router.delete("/v1/:workspaceId/notifications/:notificationId/comments/:commentId", verifyToken_1.default, commentsNotification_1.deleteComment);
exports.default = router;
