"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const verifyToken_1 = __importDefault(require("../middlewares/verifyToken"));
const multer_1 = __importDefault(require("multer"));
const categoryRecord_1 = require("../app/controllers/api/v1/categoryRecord");
const upload = (0, multer_1.default)();
const router = express_1.default.Router();
router.post("/v1/categoryRecord/:workspaceId", upload.none(), verifyToken_1.default, categoryRecord_1.createCategory);
router.get("/v1/viewAllCategoryRecord/:workspaceId", verifyToken_1.default, categoryRecord_1.viewAllCategoryRecords);
router.put("/v1/categoryRecord/:workspaceId/:categoryId", upload.none(), verifyToken_1.default, categoryRecord_1.editCategoryRecord);
router.delete("/v1/categoryRecord/:workspaceId/:categoryId", verifyToken_1.default, categoryRecord_1.deleteCategoryRecord);
exports.default = router;
