"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const categoryDocument_1 = require("../app/controllers/api/v1/categoryDocument");
const verifyToken_1 = __importDefault(require("../middlewares/verifyToken"));
const router = express_1.default.Router();
router.post("/v1/categoryDocument/:workspaceId", verifyToken_1.default, categoryDocument_1.createCategory);
router.put("/v1/categoryDocument/:workspaceId/:categoryId", verifyToken_1.default, categoryDocument_1.editCategories);
router.get("/v1/viewAllCategory/:workspaceId", verifyToken_1.default, categoryDocument_1.viewAllCategories);
router.delete("/v1/categoryDocument/:workspaceId/:categoryId", verifyToken_1.default, categoryDocument_1.deleteCategory);
exports.default = router;
