"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const firebase_admin_1 = require("../utils/firebase-admin"); // Adjust your import path for Firebase
const firebase_admin_2 = require("../utils/firebase-admin"); // Adjust your import path for Firestore
const verifyTokenSocket = (socket, next) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        // Parse cookies from the handshake headers
        const parseCookies = (cookieHeader) => {
            const cookies = {};
            if (cookieHeader) {
                cookieHeader.split(";").forEach((cookie) => {
                    const [name, ...rest] = cookie.split("=");
                    cookies[name.trim()] = rest.join("=").trim();
                });
            }
            return cookies;
        };
        // Inside your middleware or Socket.IO event
        const cookies = parseCookies(socket.handshake.headers.cookie);
        const accessToken = cookies["access_token"];
        if (!accessToken) {
            return next(new Error("No access_token found. Please log in again."));
        }
        const idToken = accessToken;
        if (!idToken) {
            return next(new Error("No token provided. Please log in again."));
        }
        // Verify Firebase ID token
        const decodedToken = yield firebase_admin_1.auth.verifyIdToken(idToken);
        const { uid } = decodedToken;
        // Fetch the user's company information from Firestore
        const companiesSnapshot = yield firebase_admin_2.adminDb.collection("companies").get();
        let companyId = null;
        let userDoc = null;
        for (const companyDoc of companiesSnapshot.docs) {
            const userSnapshot = yield companyDoc.ref
                .collection("users")
                .doc(uid)
                .get();
            if (userSnapshot.exists) {
                companyId = companyDoc.id;
                userDoc = userSnapshot.data();
                break;
            }
        }
        if (!companyId || !userDoc) {
            return next(new Error("User not found in any company."));
        }
        // Attach user data to socket object
        socket.user = Object.assign(Object.assign({}, decodedToken), { companyId, id: uid, name: userDoc.name, role: userDoc.roleId, defaultWorkspace: userDoc.defaultWorkspace });
        next(); // Proceed if everything is valid
    }
    catch (error) {
        console.error("Error verifying token:", error);
        return next(new Error("Unauthorized: Invalid or expired token."));
    }
});
// Wrap middleware for Socket.IO compatibility
const wrapMiddleware = (middleware) => (socket, next) => {
    middleware(socket, next);
};
exports.default = wrapMiddleware(verifyTokenSocket);
