"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const firebase_admin_1 = require("../utils/firebase-admin"); // Firebase Admin SDK instance
// const verifyToken = async (req: any, res: Response, next: NextFunction) => {
//   const idToken = req.cookies.access_token;
//   if (!idToken) {
//     return res
//       .status(403)
//       .json({ error: "No token provided. Please log in again." });
//   }
//   try {
//     // Step 1: Verify the Firebase ID token
//     const decodedToken = await auth.verifyIdToken(idToken);
//     const { uid } = decodedToken;
//     // Step 2: Query the Firestore to find the company the user belongs to
//     const companiesSnapshot = await adminDb.collection("companies").get();
//     let companyId: string | null = null;
//     let userDoc: any = null;
//     for (const companyDoc of companiesSnapshot.docs) {
//       const userSnapshot = await companyDoc.ref
//         .collection("users")
//         .doc(uid)
//         .get();
//       if (userSnapshot.exists) {
//         companyId = companyDoc.id;
//         userDoc = userSnapshot.data();
//         break;
//       }
//     }
//     if (!companyId || !userDoc) {
//       return res.status(404).json({ error: "User not found in any company." });
//     }
//     // Step 3: Attach user data and companyId to the request object
//     req.user = {
//       ...decodedToken,
//       companyId,
//       id: decodedToken.uid,
//       name: userDoc.name,
//       phoneNumber: userDoc.phoneNumber || null,
//       photoURL: userDoc.photoURL || null,
//       role: userDoc.roleId, // Pass other user details if necessary
//       defaultWorkspace: userDoc.defaultWorkspace,
//     };
//     next();
//   } catch (error) {
//     return res.status(403).json({ error: "Unauthorized" });
//   }
// };
const FIREBASE_API_KEY = process.env.FIREBASE_API_KEY; // Firebase API key
// Middleware to verify ID token and refresh if necessary
const verifyToken = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    var _a, _b, _c, _d, _e, _f, _g, _h;
    let idToken = req.cookies.access_token;
    const refreshToken = req.cookies.refresh_token;
    if (!idToken && !refreshToken) {
        return res
            .status(403)
            .json({ error: "No token provided. Please log in again." });
    }
    try {
        // Step 1: Try to verify the current ID token
        let decodedToken;
        if (idToken) {
            try {
                decodedToken = yield firebase_admin_1.auth.verifyIdToken(idToken, true); // force check expiration
            }
            catch (error) {
                if (error.code === "auth/id-token-expired") {
                    console.log("ID token expired, attempting to refresh token...");
                }
                else {
                    return res.status(403).json({ error: "Invalid token." });
                }
            }
        }
        // Step 2: If the access token is invalid or expired, use the refresh token to get a new ID token
        if (!decodedToken && refreshToken) {
            const response = yield fetch(`https://securetoken.googleapis.com/v1/token?key=${FIREBASE_API_KEY}`, {
                method: "POST",
                headers: {
                    "Content-Type": "application/x-www-form-urlencoded",
                },
                body: new URLSearchParams({
                    grant_type: "refresh_token",
                    refresh_token: refreshToken,
                }).toString(),
            });
            const data = yield response.json();
            if (!response.ok) {
                return res
                    .status(403)
                    .json({ error: "Unable to refresh token. Please log in again." });
            }
            const newIdToken = data.id_token;
            const newRefreshToken = data.refresh_token;
            // Set the new ID token and refresh token in cookies
            res.cookie("access_token", newIdToken, {
                httpOnly: true,
                secure: process.env.NODE_ENV === "production",
                sameSite: process.env.NODE_ENV === "production" ? "none" : "lax",
            });
            res.cookie("refresh_token", newRefreshToken, {
                httpOnly: true,
                secure: process.env.NODE_ENV === "production",
                sameSite: process.env.NODE_ENV === "production" ? "none" : "lax",
            });
            // Verify the new ID token
            decodedToken = yield firebase_admin_1.auth.verifyIdToken(newIdToken);
        }
        if (!decodedToken) {
            return res
                .status(403)
                .json({ error: "Unauthorized. Please log in again." });
        }
        const { uid } = decodedToken;
        // Step 3: Query the Firestore to find the company the user belongs to
        const companiesSnapshot = yield firebase_admin_1.adminDb.collection("companies").get();
        let companyId = null;
        let userDoc = null;
        for (const companyDoc of companiesSnapshot.docs) {
            const userSnapshot = yield companyDoc.ref
                .collection("users")
                .doc(uid)
                .get();
            if (userSnapshot.exists) {
                companyId = companyDoc.id;
                userDoc = userSnapshot.data();
                break;
            }
        }
        if (!companyId || !userDoc) {
            return res.status(404).json({ error: "User not found in any company." });
        }
        req.user = Object.assign(Object.assign({}, decodedToken), { companyId, id: decodedToken.uid, name: userDoc.name, phoneNumber: userDoc.phoneNumber || null, photoURL: userDoc.photoURL || null, role: userDoc.roleId, defaultWorkspace: userDoc.defaultWorkspace, settings: {
                notifications: {
                    approvalNotification: (_b = (_a = userDoc === null || userDoc === void 0 ? void 0 : userDoc.settings) === null || _a === void 0 ? void 0 : _a.notifications) === null || _b === void 0 ? void 0 : _b.approvalNotification,
                    commentNotification: (_d = (_c = userDoc === null || userDoc === void 0 ? void 0 : userDoc.settings) === null || _c === void 0 ? void 0 : _c.notifications) === null || _d === void 0 ? void 0 : _d.commentNotification,
                    newDocumentNotification: (_f = (_e = userDoc === null || userDoc === void 0 ? void 0 : userDoc.settings) === null || _e === void 0 ? void 0 : _e.notifications) === null || _f === void 0 ? void 0 : _f.newDocumentNotification,
                    taskNotification: (_h = (_g = userDoc === null || userDoc === void 0 ? void 0 : userDoc.settings) === null || _g === void 0 ? void 0 : _g.notifications) === null || _h === void 0 ? void 0 : _h.taskNotification,
                },
            } });
        next();
    }
    catch (error) {
        return res
            .status(403)
            .json({ error: "Token verification failed. Please log in again." });
    }
});
exports.default = verifyToken;
