"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.authenticateToken = exports.generateRefreshToken = exports.generateAccessToken = void 0;
const jsonwebtoken_1 = __importDefault(require("jsonwebtoken"));
const firebase_admin_1 = require("../utils/firebase-admin");
const JWT_SECRET_KEY = process.env.JWT_SECRET_KEY;
const JWT_REFRESH_SECRET_KEY = process.env
    .JWT_REFRESH_SECRET_KEY;
const generateAccessToken = (payload) => {
    return jsonwebtoken_1.default.sign(payload, JWT_SECRET_KEY, { expiresIn: "15m" });
};
exports.generateAccessToken = generateAccessToken;
const generateRefreshToken = (payload) => {
    return jsonwebtoken_1.default.sign(payload, JWT_REFRESH_SECRET_KEY, { expiresIn: "7d" });
};
exports.generateRefreshToken = generateRefreshToken;
const authenticateToken = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    let accessToken = req.cookies.accessToken;
    const refreshToken = req.cookies.refreshToken;
    // If access token is missing, check refresh token
    if (!accessToken && refreshToken) {
        try {
            // Verify the refresh token
            const decodedRefresh = jsonwebtoken_1.default.verify(refreshToken, JWT_REFRESH_SECRET_KEY);
            const userDoc = yield firebase_admin_1.adminDb
                .collection("users")
                .doc(decodedRefresh.id)
                .get();
            if (!userDoc.exists) {
                return res.status(401).json({
                    status: "failed",
                    code: 401,
                    message: "User not found.",
                });
            }
            const userData = userDoc.data();
            // Verify that the refresh token matches the one in the database
            if (userData.refreshToken.token !== refreshToken) {
                return res.status(401).json({
                    status: "failed",
                    code: 401,
                    message: "Invalid refresh token.",
                });
            }
            // Generate a new access token
            accessToken = generateAccessToken({
                id: userData.id,
                email: userData.email,
                name: userData.name,
                role: userData.role,
                companyId: userData.companyId,
            });
            const accessTokenExpirationDate = new Date();
            accessTokenExpirationDate.setMinutes(accessTokenExpirationDate.getMinutes() + 15);
            // Set new access token in cookies
            res.cookie("accessToken", accessToken, {
                httpOnly: true,
                secure: process.env.NODE_ENV === "production",
                sameSite: "none",
                expires: accessTokenExpirationDate,
            });
            req.user = decodedRefresh; // Pass user info from the refresh token
            return next();
        }
        catch (err) {
            return res.status(401).json({
                status: "failed",
                code: 401,
                message: "Invalid or expired refresh token. Please log in again.",
            });
        }
    }
    // If access token exists, verify it
    if (accessToken) {
        try {
            const decoded = jsonwebtoken_1.default.verify(accessToken, JWT_SECRET_KEY);
            req.user = decoded;
            return next();
        }
        catch (err) {
            return res.status(401).json({
                status: "failed",
                code: 401,
                message: "Invalid access token. Please log in again.",
            });
        }
    }
    return res.status(401).json({
        status: "failed",
        code: 401,
        message: "Not authorized to access this resource. Please log in.",
    });
});
exports.authenticateToken = authenticateToken;
