"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.doubleCsrfProtection = void 0;
const csrf_csrf_1 = require("csrf-csrf");
// CSRF Config
const CSRF_SECRET = process.env.CSRF_SECRET || "your-csrf-secret";
// Define the Double CSRF configuration
const csrfOptions = {
    getSecret: () => CSRF_SECRET,
    cookieName: "__Host-psifi.x-csrf-token",
    cookieOptions: {
        sameSite: "none",
        secure: process.env.NODE_ENV === "production",
    },
    size: 64,
    ignoredMethods: ["GET", "HEAD", "OPTIONS"],
    getTokenFromRequest: (req) => req.headers["x-csrf-token"],
};
const { doubleCsrfProtection } = (0, csrf_csrf_1.doubleCsrf)(csrfOptions);
const customDoubleCsrfProtection = (req, res, next) => {
    console.log("Token from request headers:", req.headers["x-csrf-token"]);
    console.log("Token from cookies:", req.cookies["__Host-psifi.x-csrf-token"]);
    doubleCsrfProtection(req, res, next);
};
exports.doubleCsrfProtection = customDoubleCsrfProtection;
