"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.encryptPassword = encryptPassword;
exports.checkPassword = checkPassword;
const bcrypt = require("bcryptjs");
const salt = 10;
function encryptPassword(password) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const encryptedPassword = yield bcrypt.hash(password, salt);
            return encryptedPassword;
        }
        catch (e) {
            throw new Error(e);
        }
    });
}
function checkPassword(password, encryptedPassword) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const isCorrect = yield bcrypt.compare(password, encryptedPassword);
            return isCorrect;
        }
        catch (e) {
            throw new Error(e);
        }
    });
}
