"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getRoles = exports.createRoles = void 0;
const firebase_admin_1 = require("../../../../utils/firebase-admin");
const predefinedRoles = [
    {
        id: "superadmin",
        name: "Superadmin",
        permissions: [
            "manage_users",
            "manage_admins",
            "view_all_documents",
            "edit_all_documents",
            "manage_workspaces",
        ],
        description: "Superadmin has full control over all system features.",
    },
    {
        id: "admin",
        name: "Admin",
        permissions: [
            "manage_users",
            "view_workspace_documents",
            "edit_workspace_documents",
            "manage_workspaces",
        ],
        description: "Admin can manage users and documents within their assigned workspaces.",
    },
    {
        id: "editor",
        name: "Editor",
        permissions: ["view_workspace_documents", "edit_workspace_documents"],
        description: "Editor can manage documents within their assigned workspaces.",
    },
    {
        id: "viewer",
        name: "Viewer",
        permissions: ["view_workspace_documents"],
        description: "Viewer can only view documents within their assigned workspaces.",
    },
];
const createRoles = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        if (!firebase_admin_1.adminDb) {
            throw new Error("Firestore has not been initialized.");
        }
        const batch = firebase_admin_1.adminDb.batch();
        predefinedRoles.forEach((role) => {
            const docRef = firebase_admin_1.adminDb.collection("roles").doc(role.id);
            batch.set(docRef, role);
        });
        yield batch.commit();
        return res.status(201).json({
            status: "success",
            code: 201,
            message: "Roles created successfully!",
        });
    }
    catch (error) {
        return res.status(500).json({
            status: "error",
            code: 500,
            message: "Internal Server Error",
        });
    }
});
exports.createRoles = createRoles;
const getRoles = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const rolesSnapshot = yield firebase_admin_1.adminDb.collection("roles").get();
        const roles = rolesSnapshot.docs.map((doc) => doc.data());
        return res.status(200).json({
            status: "success",
            code: 200,
            data: roles,
        });
    }
    catch (error) {
        return res.status(500).json({
            status: "error",
            code: 500,
            message: "Internal Server Error",
        });
    }
});
exports.getRoles = getRoles;
