"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateCompaniesPlan = void 0;
const firebase_admin_1 = require("../../../../utils/firebase-admin");
const updateCompaniesPlan = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const user = req.user;
        const { planId } = req.body;
        if (!user || !user.companyId) {
            return res.status(400).json({
                status: "error",
                code: 400,
                message: "User is not authenticated or Company ID is missing.",
            });
        }
        if (!planId) {
            return res.status(400).json({
                status: "error",
                code: 400,
                message: "Plan ID is required",
            });
        }
        const planRef = firebase_admin_1.adminDb.collection("plans").doc(planId);
        const planDoc = yield planRef.get();
        if (!planDoc.exists) {
            return res.status(400).json({
                status: "error",
                code: 400,
                message: "Invalid plan selected",
            });
        }
        const planData = planDoc.data();
        yield firebase_admin_1.adminDb.collection("companies").doc(user.companyId).update({
            plan: planData,
        });
        return res.status(200).json({
            status: "success",
            code: 200,
            message: "Plan updated successfully for the company",
        });
    }
    catch (error) {
        return res.status(500).json({
            status: "error",
            code: 500,
            message: "Internal Server Error",
        });
    }
});
exports.updateCompaniesPlan = updateCompaniesPlan;
